
//////////////////////////
//Created by LostSinner//
////////////////////////
using System;
using System.Collections;
using Server.Targeting;
using Server.Mobiles;

namespace Server.Items
{
    [FlipableAttribute(0xF52, 0xF51)]
    public class EmptyBloodVial1 : Item
    {
        [Constructable]
        public EmptyBloodVial1()
            : base(0xF52)
        {
            ItemID = 3620;
            Weight = 0.1;
            Hue = 0;
        }

        private void EmptyBloodVial1Target_Callback(Mobile from, object obj)
        {
            if (from.InRange(this.GetWorldLocation(), 2) == false)
            {
                from.SendLocalizedMessage(500486);	//That is too far away.
            }
            else if (obj is Corpse)
            {
                Corpse corpse = (Corpse)obj;

                if (corpse != null && !((Item)corpse).Deleted && corpse.CanLoot(from))
                {
                    if (corpse.Owner is VampireMage || corpse.Owner is VampireWarrior || corpse.Owner is VampireArcher ||
                    corpse.Owner is VampireYoung || corpse.Owner is Vampire || corpse.Owner is VampireElder || corpse.Owner is VampireAncient || corpse.Owner is VampireLord)
                    {
                        from.AddToBackpack(new VampiresBlood());
                        from.SendMessage("Nabral jsi upiri krev");
                        this.Delete();
                        corpse.Delete();
                        return;
                    }
                    else
                    {
                        from.SendMessage("Toto neni mrtvola vampira!");
                    }
                }
                else
                {
                    from.SendMessage("Toto monstrum jsi nezabil ty!");
                }
            }
            else
            {
                from.SendMessage("Toto neni mrtvola!");
            }
        }

        public override void OnDoubleClick(Mobile from)
        {
            if (!IsChildOf(from.Backpack))
            {
                from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
            }
            else
            {
                from.BeginTarget(-1, false, TargetFlags.Harmful, new TargetCallback(EmptyBloodVial1Target_Callback));
                from.SendMessage("Zamer mrtvolu vampira.");
            }
        }

        public EmptyBloodVial1(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }
}